<?php 
    /**
    *
    * copyright (c) 2013-2022 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "include/includeBase.php";
    
    include "include/controlloLogin.php";
    
    $datiStatistiche   = $geecomDb->leggiSingolaRiga("geecD_statistiche",1);
    
    $dataOggi    = new DateTime();
    $dataInstallazione = new DateTime($datiStatistiche["dataInstallazione"]);
    $intervallo = $dataOggi->diff($dataInstallazione);
    $differenzaGiorni = $intervallo->format('%d');
    
    $queryUltimoUtente = "SELECT * FROM geec_utenti WHERE ruolo LIKE 'utente' ORDER BY id LIMIT 1";
    $risUltimoUtente   = $geecomDb->eseguiQueryLettura($queryUltimoUtente);
    
    
?>
<!doctype html>
<html lang="en">
    <head>
        <!-- Required meta tags -->
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <title>Amministrazione di Geecom Doc - statistiche</title>
        <?php
            include "include/cssBaseAreaAmministrativa.php";
        ?>
    </head>
    
    <body>
        
        <header>  
            <?php  
                include "include/barraSuperiore.php";

                include "include/header.php";

                include "include/barraMenu.php";
            ?>
        </header>
        
        <main role="main" class="bg-light" id="main">
		<div id="dashboard" class="container-fluid">
                    <div class="row">
                        <div class="col-sm-5 col-lg-4 col-xl-3">
                            <div id="riepilogo-SEO" class="card my-4 accordion box-shadow-lite">
                                <div class="card-header collapsed" data-toggle="collapse" href="#SEOgenerale">
                                    <a class="card-title">
                                        Statistiche generali
                                    </a>
                                </div>
                                <div id="SEOgenerale" class="collapse show">
                                    <div class="card-body">
                                        <div class="alert border-<?php echo $datiUtilizzoPiattaforma["classeBoxUtilizzo"]; ?> text-<?php echo $datiUtilizzoPiattaforma["classeBoxUtilizzo"]; ?> col-12 text-center mb-0 seo">
                                            <h5 class="mb-3"><i class="far fa-hdd mr-2"></i>Spazio occupato</h5>
                                            <?php
                                                $spazioOccupato = $geecomDb->sommaValoriColonna("dimensione","geecD_versioniDocumento");

                                                if(!is_numeric($spazioOccupato)) {
                                                    $spazioOccupato = 0;
                                                } 

                                                $valore1PerCento = $impostazioni["spazioSuDiscoDaOccupareInMb"] / 100;

                                                if($spazioOccupato<$valore1PerCento/2) {
                                                    $percentualeSpazioOccupato = 0;
                                                }
                                                else if($spazioOccupato<=$valore1PerCento) {
                                                    $percentualeSpazioOccupato = 1;
                                                }
                                                else {
                                                    $percentualeSpazioOccupato =  round($spazioOccupato / $impostazioni["spazioSuDiscoDaOccupareInMb"] * 100,2);
                                                }
                                            ?>
                                            <div class="progress mb-2">
                                                <div class="progress-bar" role="progressbar" style="width: <?php echo $percentualeSpazioOccupato ?>%;" aria-valuenow="<?php echo $percentualeSpazioOccupato ?>" aria-valuemin="0" aria-valuemax="100"><?php echo $percentualeSpazioOccupato ?>%</div>
                                            </div>
                                            <small ><?php echo $spazioOccupato ?> Mb occupati su <?php echo $impostazioni["spazioSuDiscoDaOccupareInMb"] ?> Mb disponibili</small>
                                        </div>
                                        <hr>
                                        <p><i class="fas fa-exclamation-triangle"></i> La piattaforma è attiva da <?php echo $differenzaGiorni ?> giorni</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Colonna principale -->
                        <div class="col-sm-7 col-lg-8 col-xl-9 py-4" id="riepilogoStatistiche">
                            <div class="row mb-4">
                                <div class="col-12">
                                    <div class="card mb-4 accordion box-shadow-lite">
                                        <div class="card-header collapsed" data-toggle="collapse" href="#interazioniSito">
                                            <a class="card-title">
                                                Spazio occupato per singolo utente
                                            </a>
                                        </div>
                                        <div id="interazioniSito" class="collapse show">
                                            <div class="card-body">
                                                <div class="row">
                                                    <?php 
                                                        $queryUtenti = "SELECT * FROM geec_utenti";
                                                        $risUtenti   = $geecomDb->eseguiQueryLettura($queryUtenti);
                                                        
                                                        while($utente = $risUtenti->fetch_assoc()) {
                                                            ?>
                                                            <div class="col-md-4 mb-4">
                                                                <h5 class="mb-3"><i class="far fa-hdd mr-2"></i><?php echo $utente["nome"]." ".$utente["cognome"] ?></h5>
                                                                <?php
                                                                    $query = "SELECT SUM(dimensione) FROM geecD_versioniDocumento WHERE idDocumento IN (SELECT id FROM geecD_documenti WHERE utente = {$utente["id"]})";
                                                                    $ris   = $geecomDb->eseguiQueryLettura($query);
                                                                    $arrayConteggio = $ris->fetch_array(MYSQLI_NUM);
                                                                    $spazioOccupato = $arrayConteggio[0];

                                                                    if(!is_numeric($spazioOccupato)) {
                                                                        $spazioOccupato = 0;
                                                                    }
                                                                    
                                                                    $valore1PerCento = $impostazioni["spazioSuDiscoDaOccupareInMb"] / 100;

                                                                    if($spazioOccupato<$valore1PerCento/2) {
                                                                        $percentualeSpazioOccupato = 0;
                                                                    }
                                                                    else if($spazioOccupato<=$valore1PerCento) {
                                                                        $percentualeSpazioOccupato = 1;
                                                                    }
                                                                    else {
                                                                        $percentualeSpazioOccupato =  round($spazioOccupato / $impostazioni["spazioSuDiscoDaOccupareInMb"] * 100,2);
                                                                    }
                                                                ?>
                                                                <div class="progress mb-2">
                                                                    <div class="progress-bar" role="progressbar" style="width: <?php echo $percentualeSpazioOccupato ?>%;" aria-valuenow="<?php echo $percentualeSpazioOccupato ?>" aria-valuemin="0" aria-valuemax="100"><?php echo $percentualeSpazioOccupato ?>%</div>
                                                                </div>
                                                                <small ><?php echo $spazioOccupato ?> Mb occupati su <?php echo $impostazioni["spazioSuDiscoDaOccupareInMb"] ?> Mb disponibili</small> 
                                                            </div>
                                                            <?php
                                                        }
                                                    ?>
                                                    
                                                    <div class="col-md-4 mb-4">
                                                        <h5 class="mb-3"><i class="far fa-hdd mr-2"></i>Documenti senza proprietario</h5>
                                                        <?php
                                                            $query = "SELECT SUM(dimensione) FROM geecD_versioniDocumento WHERE idDocumento IN (SELECT id FROM geecD_documenti WHERE utente = 0)";
                                                            $ris   = $geecomDb->eseguiQueryLettura($query);
                                                            $arrayConteggio = $ris->fetch_array(MYSQLI_NUM);
                                                            $spazioOccupato = $arrayConteggio[0];

                                                            if(!is_numeric($spazioOccupato)) {
                                                                $spazioOccupato = 0;
                                                            }

                                                            $valore1PerCento = $impostazioni["spazioSuDiscoDaOccupareInMb"] / 100;

                                                            if($spazioOccupato<$valore1PerCento/2) {
                                                                $percentualeSpazioOccupato = 0;
                                                            }
                                                            else if($spazioOccupato<=$valore1PerCento) {
                                                                $percentualeSpazioOccupato = 1;
                                                            }
                                                            else {
                                                                $percentualeSpazioOccupato =  round($spazioOccupato / $impostazioni["spazioSuDiscoDaOccupareInMb"] * 100,2);
                                                            }
                                                        ?>
                                                        <div class="progress mb-2">
                                                            <div class="progress-bar" role="progressbar" style="width: <?php echo $percentualeSpazioOccupato ?>%;" aria-valuenow="<?php echo $percentualeSpazioOccupato ?>" aria-valuemin="0" aria-valuemax="100"><?php echo $percentualeSpazioOccupato ?>%</div>
                                                        </div>
                                                        <small ><?php echo $spazioOccupato ?> Mb occupati su <?php echo $impostazioni["spazioSuDiscoDaOccupareInMb"] ?> Mb disponibili</small> 
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>
                        </div><!-- /Colonna principale -->
                    </div>
		</div>
    </main>

    <?php 
        include "include/footer.php";
        
        include "include/modal/cambiaPassword.php";
        
        include "include/modal/modalMenuComponenti.php";
        
        include "include/jsBaseAreaAmministrativa.php";
    ?>  
	  
        <script>
            /*
             * Replace all SVG images with inline SVG
             */
            jQuery('img.svg').each(function(){
                var $img = jQuery(this);
                var imgID = $img.attr('id');
                var imgClass = $img.attr('class');
                var imgURL = $img.attr('src');

                jQuery.get(imgURL, function(data) {
                        // Get the SVG tag, ignore the rest
                        var $svg = jQuery(data).find('svg');

                        // Add replaced image's ID to the new SVG
                        if(typeof imgID !== 'undefined') {
                                $svg = $svg.attr('id', imgID);
                        }
                        // Add replaced image's classes to the new SVG
                        if(typeof imgClass !== 'undefined') {
                                $svg = $svg.attr('class', imgClass+' replaced-svg');
                        }

                        // Remove any invalid XML tags as per http://validator.w3.org
                        $svg = $svg.removeAttr('xmlns:a');

                        // Check if the viewport is set, if the viewport is not set the SVG wont't scale.
                        if(!$svg.attr('viewBox') && $svg.attr('height') && $svg.attr('width')) {
                                $svg.attr('viewBox', '0 0 ' + $svg.attr('height') + ' ' + $svg.attr('width'))
                        }

                        // Replace image with new SVG
                        $img.replaceWith($svg);

                }, 'xml');
            });
	  
        </script>
	  
  </body>
</html>

<?php

    function stampaBoxStatistica($titoloSezione,$classeTestuale,$classeFaccina,$numeroELementi,$frase,$link,$classeAggiuntivaDiv = "") {
        ?>
        <div class="col-lg-4 col-xl-12 mb-5 mb-lg-0 <?php echo $classeAggiuntivaDiv ?> text-center">
            <h6 class="<?php echo $classeTestuale ?>"> <i class="<?php echo $classeFaccina ?>"></i></h6>
            <h6 class="<?php echo $classeTestuale ?>"><strong><?php echo $numeroELementi ?></strong> <?php echo $titoloSezione ?></h6>
            <p><?php echo $frase ?></p>
            <a href="<?php echo $link ?>" class="btn btn-primary btn-block btn-sm text-white leggi-tutto mt-3">Dettagli</a>
        </div>
        <?php
    }